/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.websm.updates;

import com.ibm.hsc.websm.updates.PIUpdateableComponent;
import com.ibm.hsc.websm.updates.PIUpdatesOwner;
import com.ibm.hwmca.fw.managed.ManagedObject;
import com.ibm.hwmca.fw.managed.ObjectId;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.xfw.updates.UpdateManager;
import com.ibm.hwmca.xfw.updates.UpdatesOwner;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

class OwnerManager {
    private static final String TRACE_MASKT = "XUPDTOMT";
    private static final String TRACE_MASKF = "XUPDTOMF";
    private static final String TRACE_MASKD = "XUPDTOMD";
    private UpdateManager theUpdateManager;
    private Map updatesOwnersMap = new Hashtable();
    private static OwnerManager ownerManager = new OwnerManager();

    private OwnerManager() {
    }

    static OwnerManager getOwnerManager() {
        return ownerManager;
    }

    private void addOwnerForTarget(ObjectId objectId, UpdatesOwner updatesOwner) {
        this.updatesOwnersMap.put(objectId, updatesOwner);
    }

    UpdatesOwner getOwnerForManagedObject(ManagedObject managedObject) {
        Trace.trace((String)TRACE_MASKT, (Object)"-> OwnerManager.getOwnerForManagedObject()");
        UpdatesOwner updatesOwner = null;
        ObjectId objectId = managedObject.getObjectId();
        updatesOwner = (UpdatesOwner)this.updatesOwnersMap.get(objectId);
        if (null == updatesOwner) {
            Trace.trace((String)TRACE_MASKF, (Object)" [getOwnerForManagedObject()] Retrieve the updates owner object from the UpdateManager.");
            updatesOwner = this.getUpdateManager().getOwnerForManagedObject(managedObject);
            if (null != updatesOwner) {
                this.addOwnerForTarget(objectId, updatesOwner);
            }
        }
        Trace.trace((String)TRACE_MASKT, (Object)("<- OwnerManager.getOwnerForManagedObject() returning: " + updatesOwner));
        return updatesOwner;
    }

    private UpdateManager getUpdateManager() {
        if (null == this.theUpdateManager) {
            this.theUpdateManager = UpdateManager.getUpdateManager();
        }
        return this.theUpdateManager;
    }

    public void traceDebugInfo() {
        Trace.trace((String)TRACE_MASKT, (Object)"-> OwnerManager.traceDebugInfo()");
        Set set = this.updatesOwnersMap.keySet();
        Trace.trace((String)TRACE_MASKT, (Object)(" There are " + set.size() + " updates owner objects in OwnerManager."));
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            ObjectId objectId = (ObjectId)iterator.next();
            Trace.trace((String)TRACE_MASKT, (Object)("   Details for objectID: " + objectId));
            UpdatesOwner updatesOwner = (UpdatesOwner)this.updatesOwnersMap.get(objectId);
            if (updatesOwner instanceof PIUpdatesOwner) {
                try {
                    List list = updatesOwner.getUpdateableComponents();
                    Iterator iterator2 = list.iterator();
                    while (iterator2.hasNext()) {
                        PIUpdateableComponent pIUpdateableComponent = (PIUpdateableComponent)iterator2.next();
                        Trace.trace((String)TRACE_MASKT, (Object)("   [EC number:" + pIUpdateableComponent.getECNumber() + "]"));
                        Trace.trace((String)TRACE_MASKT, (Object)("   [MTMS:" + pIUpdateableComponent.getMTMS() + "]"));
                        Trace.trace((String)TRACE_MASKT, (Object)("   [Applied level:" + pIUpdateableComponent.getAppliedLevel() + "]"));
                        Trace.trace((String)TRACE_MASKT, (Object)("   [Apply-in-progress level:" + pIUpdateableComponent.getApplyInProgressLevel() + "]"));
                        Trace.trace((String)TRACE_MASKT, (Object)("   [Committed level:" + pIUpdateableComponent.getCommittedLevel() + "]"));
                        Trace.trace((String)TRACE_MASKT, (Object)("   [Nondisruptive apply level:" + pIUpdateableComponent.getNonDisruptiveApplyLevel() + "]"));
                        Trace.trace((String)TRACE_MASKT, (Object)("   [Nondisruptive reject level:" + pIUpdateableComponent.getNonDisruptiveRejectLevel() + "]"));
                        Trace.trace((String)TRACE_MASKT, (Object)("   [Nondisruptive stagable level:" + pIUpdateableComponent.getNonDisruptiveStagableLevel() + "]"));
                        Trace.trace((String)TRACE_MASKT, (Object)("   [Stageable level:" + pIUpdateableComponent.getStagableLevel() + "]"));
                        Trace.trace((String)TRACE_MASKT, (Object)("   [Staged level:" + pIUpdateableComponent.getStagedLevel() + "]"));
                        Trace.trace((String)TRACE_MASKT, (Object)("   [isConcurrentUpdatingEnabled:" + pIUpdateableComponent.isConcurrentUpdatingEnabled() + "]"));
                        Trace.trace((String)TRACE_MASKT, (Object)("   [isUpdatingEnabled:" + pIUpdateableComponent.isUpdatingEnabled() + "]"));
                    }
                    continue;
                }
                catch (Exception exception) {
                    Trace.trace((String)TRACE_MASKT, (Object)"   [Got exception getting the associated updateable components.]");
                    continue;
                }
            }
            Trace.trace((String)TRACE_MASKT, (Object)"   [The associated object is not an instance of PIUpdatesOwner.]");
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<- OwnerManager.traceDebugInfo()");
    }
}

